<?php
error_reporting(0);
defined("ACCESS") or die('Konz');

class core 
{
	private $_LICENSE = FCPATH . "arahmataAngin/system/private/license.ini";
	private $_CONFIG = FCPATH. "arahmataAngin/system/private/setting.json";
	private $license;

	public function __construct()
	{
		if (!is_file($this->_LICENSE)) {
			header("location: install.php");
			exit();
		}

		$_ini_file = parse_ini_file($this->_LICENSE);
		$this->license = new license($_ini_file);

		if(!$this->license->validate()['status']){
			return $this->license->validate()['message'];
		}
	}

	public function runApp()
	{
		$uri = trim($_GET['z']);
		$uri = explode("/", $uri);

		if (!isset($_GET['z'])) {
			$controller = "Home";
		} else {
			$controller = ucfirst($uri[0]);
		}

		if (file_exists(FCPATH . "arahmataAngin/application/controllers/". $controller. ".php")) {
			require FCPATH . "arahmataAngin/application/controllers/". $controller . ".php";
			$controller = new $controller;

		} else {
			_404("Unknown Controller {$controller}");
		}

		if (isset($uri[1]) and (!empty($uri[1]))) {
			$method = trim($uri[1]);
			if (method_exists($controller, $method)) {
				$controller->$method();
			} else {
				_404("Unknown method {$method}");				
			}
		} else {
			$controller->index();
		}
	}
}